/*---------------------------------------------*\
|  Servo Driver					|
|  Contains functions used to drive ATMega328	|
|  Servo Driver and Arduino Vex Robot Controller|
\*---------------------------------------------*/

#include "servo.h"

/*---------------------------------------------*\
|  Constructors					|
|  Specifying the port name is optional,	|
|  default is /dev/ttyUSB0			|
\*---------------------------------------------*/
Servo_driver::Servo_driver()
{
  serialOpen("/dev/ttyUSB0");
}

Servo_driver::Servo_driver(string dev)
{
  serialOpen(dev);
}
/////////////////////////////////////////////////

/*---------------------------------------------*\
|  Serial Open					|
|  Opens the specified serial port, saves	|
|  file descriptor				|
\*---------------------------------------------*/
void Servo_driver::serialOpen(string dev)
{
  portfd = open(dev.c_str(), O_RDWR | O_NOCTTY | O_NDELAY);

  if (portfd == -1)
  {
    cout << "Unable to open port " << dev << endl;
  }
  else
  {
    fcntl(portfd, F_SETFL, 0);
  }
}
/////////////////////////////////////////////////

/*---------------------------------------------*\
|  Settters with Serial Port Functionality	|
\*---------------------------------------------*/
void Servo_driver::set_motors(char m1, char m2)
{
  motor1_speed = m1;
  motor2_speed = m2;
  set_motors();
}

void Servo_driver::set_motors()
{
  char buffer[4] = {255, motor1_speed, motor2_speed, 200};
  write(portfd, buffer, 4);
  usleep(20000);
}

void Servo_driver::set_speed_limit(char m1l, char m2l)
{
  motor1_limit = m1l;
  motor2_limit = m2l;
  set_speed_limit();
}

void Servo_driver::set_speed_limit()
{
  char buffer[4] = {254, motor1_limit, motor2_limit, 200};
  write(portfd, buffer, 4);
  usleep(20000);
}
/////////////////////////////////////////////////

/*---------------------------------------------*\
|  Other Setters				|
\*---------------------------------------------*/
void Servo_driver::set_motor1_speed(char m1)
{
  motor1_speed = m1;
}

void Servo_driver::set_motor2_speed(char m2)
{
  motor2_speed = m2;
}

void Servo_driver::set_motor1_limit(char m1l)
{
  motor1_limit = m1l;
}

void Servo_driver::set_motor2_limit(char m2l)
{
  motor2_limit = m2l;
}
/////////////////////////////////////////////////
